/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.base.StringUtils;
import filenet.vw.base.logging.Logger;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PunycodeUtils {
    private static Map<String, String> ASCIINames = Collections.synchronizedMap(new HashMap(10));
    private static Map<String, String> UnicodeNames = Collections.synchronizedMap(new HashMap(10));
    private static final String m_className = "PunycodeUtils";
    protected static Logger logger = Logger.getLogger("filenet.vw.base");
    private static Method UNICODE_to_ASCII_Method = null;
    private static Method ASCII_to_Unicode_Method = null;

    public static URI toASCIIURI(URI hostURI) {
        if (hostURI == null) {
            return hostURI;
        }
        try {
            String s = PunycodeUtils.toASCIIURL(hostURI.toString());
            if (s != null) {
                return new URI(s);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return hostURI;
    }

    public static boolean allASCII(String host) {
        int len = host == null ? 0 : host.length();
        for (int i = 0; i < len; ++i) {
            if (host.charAt(i) <= '\u0080') continue;
            return false;
        }
        return true;
    }

    public static void parseURI(String s) {
        try {
            URI uri = new URI(s);
            System.out.println("uri.getScheme=" + uri.getScheme());
            System.out.println("uri.getSchemeSpecificPart=" + uri.getSchemeSpecificPart());
            System.out.println("uri.getAuthority=" + uri.getAuthority());
            System.out.println("uri.getUserInfo=" + uri.getUserInfo());
            System.out.println("uri.getHost=" + uri.getHost());
            System.out.println("uri.getPort=" + uri.getPort());
            System.out.println("uri.getPath=" + uri.getPath());
            System.out.println("uri.getQuery=" + uri.getQuery());
            System.out.println("uri.getFragment=" + uri.getFragment());
            System.out.println("uri.toASCIIString=" + uri.toASCIIString());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toASCIIURL(String hostURLStr) {
        String newHostName;
        URL idnURI;
        String m_method;
        String key;
        block10: {
            String hostName;
            block9: {
                if (hostURLStr == null || !hostURLStr.startsWith("http") || UNICODE_to_ASCII_Method == null) {
                    return hostURLStr;
                }
                key = hostURLStr;
                if (ASCIINames.containsKey(key)) {
                    return ASCIINames.get(key);
                }
                m_method = "toASCIIURL:" + hostURLStr;
                idnURI = new URL(hostURLStr);
                hostName = idnURI.getHost();
                if (hostName != null) break block9;
                String string = hostURLStr;
                Object var8_8 = null;
                return string;
            }
            newHostName = PunycodeUtils.toASCII(hostName);
            if (newHostName == null || !newHostName.equals(hostName)) break block10;
            String string = hostURLStr;
            Object var8_9 = null;
            return string;
        }
        try {
            try {
                String query = idnURI.getQuery();
                hostURLStr = idnURI.getProtocol() + "://" + newHostName + ":" + idnURI.getPort() + "/" + idnURI.getPath() + (query == null ? "" : "?" + query);
            }
            catch (Throwable t) {
                if (logger.isFinest()) {
                    logger.throwing(m_className, m_method, t);
                }
                Object var8_11 = null;
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            throw throwable;
        }
        ASCIINames.put(key, hostURLStr);
        UnicodeNames.put(hostURLStr, key);
        return hostURLStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toASCII(String hostStr) {
        if (hostStr == null || UNICODE_to_ASCII_Method == null) {
            return hostStr;
        }
        String key = hostStr;
        if (ASCIINames.containsKey(key)) {
            return ASCIINames.get(key);
        }
        String m_method = "toASCII:" + hostStr;
        if (UNICODE_to_ASCII_Method != null) {
            block9: {
                hostStr = URLDecoder.decode(hostStr, "UTF-8");
                if (!PunycodeUtils.allASCII(hostStr)) break block9;
                String string = hostStr;
                Object var5_5 = null;
                return string;
            }
            try {
                try {
                    hostStr = (String)UNICODE_to_ASCII_Method.invoke(null, hostStr);
                }
                catch (Throwable t) {
                    if (logger.isFinest()) {
                        logger.throwing(m_className, m_method, t);
                    }
                    Object var5_7 = null;
                }
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                throw throwable;
            }
        }
        ASCIINames.put(key, hostStr);
        UnicodeNames.put(hostStr, key);
        return hostStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toUnicode(String hostStr) {
        if (hostStr == null || ASCII_to_Unicode_Method == null) {
            return hostStr;
        }
        String key = hostStr;
        if (UnicodeNames.containsKey(key)) {
            return UnicodeNames.get(key);
        }
        if (ASCII_to_Unicode_Method != null) {
            try {
                try {
                    hostStr = (String)ASCII_to_Unicode_Method.invoke(null, hostStr);
                }
                catch (Throwable t) {
                    if (logger.isFinest()) {
                        logger.throwing(m_className, "toUnicode", t);
                    }
                    Object var4_3 = null;
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
        UnicodeNames.put(key, hostStr);
        ASCIINames.put(hostStr, key);
        return hostStr;
    }

    public static URI toUnicodeURI(URI hostURI) {
        block4: {
            if (hostURI == null) {
                return hostURI;
            }
            try {
                String s = PunycodeUtils.toUnicodeURL(hostURI.toString());
                if (s != null) {
                    return new URI(s);
                }
            }
            catch (Throwable t) {
                if (!logger.isFinest()) break block4;
                logger.throwing(m_className, "toUnicodeURI", t);
            }
        }
        return hostURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toUnicodeURL(String hostURLStr) {
        String newHostName;
        URL asciiURI;
        String key;
        block10: {
            String hostName;
            block9: {
                if (hostURLStr == null || !hostURLStr.startsWith("http") || ASCII_to_Unicode_Method == null) {
                    return hostURLStr;
                }
                key = hostURLStr;
                if (UnicodeNames.containsKey(key)) {
                    return UnicodeNames.get(key);
                }
                asciiURI = new URL(hostURLStr);
                hostName = asciiURI.getHost();
                if (hostName != null) break block9;
                String string = hostURLStr;
                Object var7_7 = null;
                return string;
            }
            newHostName = PunycodeUtils.toUnicode(hostName);
            if (newHostName == null || !newHostName.equals(hostName)) break block10;
            String string = hostURLStr;
            Object var7_8 = null;
            return string;
        }
        try {
            try {
                newHostName = URLEncoder.encode(newHostName, "UTF-8");
                String query = asciiURI.getQuery();
                hostURLStr = asciiURI.getProtocol() + "://" + newHostName + ":" + asciiURI.getPort() + "/" + asciiURI.getPath() + (query == null ? "" : "?" + query);
            }
            catch (Throwable t) {
                if (logger.isFinest()) {
                    logger.throwing(m_className, "toUnicodeURL", t);
                }
                Object var7_10 = null;
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            throw throwable;
        }
        UnicodeNames.put(key, hostURLStr);
        ASCIINames.put(hostURLStr, key);
        return hostURLStr;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   15 Sep 2010 11:21:54  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.0  $";
    }

    public static void connectToHost(String host, int timeoutInMs, int port) {
        try {
            InetAddress[] addrs = InetAddress.getAllByName(host);
            if (addrs != null) {
                for (InetAddress anAddr : addrs) {
                    System.out.println("\n**Trying to reach " + anAddr.getCanonicalHostName() + " with timeout(ms)=" + timeoutInMs);
                    if (port > 0) {
                        InetSocketAddress socketAddr = new InetSocketAddress(anAddr, port);
                        Socket socket = new Socket();
                        socket.connect(socketAddr, timeoutInMs);
                        socket.close();
                    } else {
                        anAddr.isReachable(timeoutInMs);
                    }
                    System.out.println(anAddr.getCanonicalHostName() + " can be reached OK..");
                }
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            String s;
            VWCommandLineArgs c = new VWCommandLineArgs(args);
            if (c.isPresent("h") || c.isPresent("?")) {
                System.out.println("PunycodeUtils /2unicode <asciiHost>");
                System.out.println("  OR /2ascii <unicodeHost> /urlencoded");
                System.out.println(" can combine with /test <timeoutInMs> [ /port <port> ]to connect to the host");
                System.out.println(" /uri <URI> for parsing the uri..");
                System.exit(0);
            }
            int timeout = -1;
            int port = -1;
            if (c.isPresent("uri")) {
                PunycodeUtils.parseURI(c.getParameter("uri"));
                return;
            }
            if (c.isPresent("test")) {
                timeout = c.getIntParameter("test", 30000);
                port = c.getIntParameter("port", -1);
            }
            System.out.println("\nChecking arguments..");
            c.list(System.out);
            System.out.println("\n-----------------------");
            String host = c.getParameter("2unicode");
            if (host != null) {
                s = PunycodeUtils.toUnicode(host);
                System.out.println("Given ASCII Host:" + host);
                System.out.println("Got Unicode Host:" + s + ", bytesFormat:" + StringUtils.printBytes(s, "UTF-8"));
                if (timeout > 0) {
                    System.out.println("Try the original ASCII host first:" + host);
                    PunycodeUtils.connectToHost(host, timeout, port);
                    System.out.println("Try the new UNICODE host:" + s);
                    PunycodeUtils.connectToHost(s, timeout, port);
                }
                String ascii = PunycodeUtils.toASCII(s);
                System.out.println("-- back to ASCII: " + ascii);
                if (ascii.equals(host)) {
                    System.out.println("Great conversion looks good OK!!");
                } else {
                    System.err.println("Not OK!!!");
                }
            }
            if ((host = c.getParameter("2ascii")) != null) {
                s = PunycodeUtils.toASCII(host);
                System.out.println("Given Unicode Host:" + host);
                System.out.println("Got ASCII Host:" + s + ", bytesFormat:" + StringUtils.printBytes(s, "UTF-8"));
                if (timeout > 0) {
                    boolean wasEncoded = c.isPresent("urlencoded");
                    if (wasEncoded) {
                        host = URLDecoder.decode(host, "UTF-8");
                    }
                    System.out.println("Try the original host " + (wasEncoded ? "**decoded**" : "") + " first:" + host);
                    PunycodeUtils.connectToHost(host, timeout, port);
                    System.out.println("Try the new host:" + s);
                    PunycodeUtils.connectToHost(s, timeout, port);
                }
                String uniHost = PunycodeUtils.toUnicode(s);
                System.out.println("-- back to ASCII: " + uniHost);
                if (uniHost.equals(host)) {
                    System.out.println("Great conversion looks good OK!!");
                } else {
                    System.err.println("Not OK!!!");
                }
            }
            byte[] b = new byte[]{-27, -115, -127, -27, -123, -108, -23, -91, -123};
            host = new String(b, "UTF-8");
            String url = "http://" + host + ":7001/wsi/FNCEWS40MTOM/";
            PunycodeUtils.parseURI(url);
            System.out.println("----------------------------------");
            PunycodeUtils.parseURI("corbaloc::" + host + ":32771/," + host + "%E5%8D%81%E5%85%94%E9%A5%85:2334/FileNet/Engine");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            Class<?> cls = Class.forName("java.net.IDN");
            UNICODE_to_ASCII_Method = cls.getMethod("toASCII", String.class);
            ASCII_to_Unicode_Method = cls.getMethod("toUnicode", String.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

